%% Save AMPC results
% Create structures to save
simlog = simlog_ElectricVehicleThermalManagement;

%% Time 
time = BatteryTemperature.time;

%% Battery
% Battery
battery.Q_joule = Q_joule.signals.values;
battery.T = BatteryTemperature.signals.values;
battery.i_tot = i_battery.signals.values; % total current (traction + compressor + etc..)
battery.i_BMS = i_BMS.signals.values; % traction
battery.T_env = battery.T(1) * ones(size(battery.T));

%% Electric powers and energy
% Electic powers (W)
EPowers.Compressor = EPower_Compressor.signals.values;
EPowers.Fan = EPower_Fan.signals.values;
EPowers.MotorPump = EPower_MotorPump.signals.values;
EPowers.BatteryPump = EPower_BatteryPump.signals.values;
battery.V = Voltage_battery.signals.values;
% Electric energies (J)
ElectricEnergy.battery_BTM = Energy_BTM.signals.values;
ElectricEnergy.battery_tot = Energy_battery.signals.values;
ElectricEnergy.battery_PowerTrain = Energy_battery.signals.values - Energy_BTM.signals.values;
ElectricEnergy.battery_BTM_compressor = Energy_compressor.signals.values;
ElectricEnergy.battery_BTM_fan = Energy_fan.signals.values;
Distance = distance_km.signals.values;

% Heat flows
% computing heat power taken from the battery by means of BMS (Qbms)
battery.coolant_Q_BMS = Phi_battery_out.signals.values-Phi_battery_in.signals.values;
% % difference between Qjoule and Qbms
% battery.coolant.DeltaQ = battery.Q_joule.signals.values-battery.coolant_Q_BMS.values;


%% HVAC
%% Cabin
if exist('T_cabin')
    % Cabin
    cabin.T_cabin = T_cabin.signals.values;
    cabin.T_target = T_target_HVAC;
    cabin.Q_cabin_HVAC = Q_cabin_HVAC.signals.values;
    cabin.Q_evap_HVAC = Qdot_evap.signals.values;
    cabin.Q_cabin_convection = Q_cabin_convection.signals.values;

    %% Thermodynamical quantities
    % Mass flow rates (kg/s)
    battery.mdot_coolant = mdot_coolant_battery_in.signals.values;
    cabin.mdot_blower = mdot_air_blower.signals.values;
    chiller.mdot_2P = mdot_chiller_2P_out.signals.values;
    chiller.mdot_TL = mdot_chiller_TL_in.signals.values;
    % chillerByPassValve.mdot.in = mdot_ChillerByPassValve_in.signals.values;
    % chillerByPassValve.mdot.outB = mdot_ChillerByPassValve_outB.signals.values;
    % chillerByPassValve.mdot.outC = mdot_ChillerByPassValve_outC.signals.values;
    % compressor.fluid.mdot.in = mdot_comp_in.signals.values;
    % compressor.fluid.mdot.out = mdot_comp_out.signals.values;
    % condenser.TwoP.mdot.out = mdot_cond_2P_out.signals.values;
    % condenser.TwoP.mdot.in = mdot_cond_in.signals.values;
end

% % Pressure (MPa)
% chiller.TwoP.p.in = p_chiller_2P_in.signals.values;
% chiller.TwoP.p.out = p_chiller_2P_out.signals.values;
% chiller.TL.p.in = p_chiller_TL_in.signals.values;
% chiller.TL.p.out = p_chiller_TL_out.signals.values;
% chillerByPassValve.p.in = p_ChillerByPassValve_in.signals.values;
% chillerByPassValve.p.outB = p_ChillerByPassValve_outB.signals.values;
% chillerByPassValve.p.outC = p_ChillerByPassValve_outC.signals.values;
% compressor.fluid.p.in = p_comp_in.signals.values;
% compressor.fluid.p.out = p_comp_out.signals.values;
% condenser.TwoP.p.in = p_cond_2P_in.signals.values;
% condenser.TwoP.p.out = p_cond_2P_out.signals.values;
% battery.coolant.SC3.p = p_coolant_battery_in.signals.values;
% battery.coolant.SC4.p = p_coolant_battery_out.signals.values;
% % Energy flow rates (W)
% battery.coolant.SC3.Phi = Phi_battery_in.signals.values;
% battery.coolant.SC4.Phi = Phi_battery_out.signals.values;
% chiller.TwoP.Phi.in = Phi_chiller_2P_in.signals.values;
% chiller.TwoP.Phi.out = Phi_chiller_out.signals.values;
% chiller.TL.Phi.in = Phi_chiller_TL_in.signals.values;
% chiller.TL.Phi.out = Phi_chiller_TL_out.signals.values;
% chillerByPassValve.Phi.in = Phi_ChillerByPassValve_in.signals.values;
% chillerByPassValve.Phi.outB = Phi_ChillerByPassValve_outB.signals.values;
% chillerByPassValve.Phi.outC = Phi_ChillerByPassValve_outC.signals.values;
% compressor.fluid.Phi.in = Phi_comp_in.signals.values;
% compressor.fluid.Phi.out = Phi_comp_out.signals.values;
% condenser.TwoP.Phi.in = Phi_cond_in.signals.values;
% condenser.TwoP.Phi.out = Phi_cond_out.signals.values;
% chiller.TL.rho.in = rho_chiller_TL_in.signals.values;
% chiller.TL.rho.out = rho_chiller_TL_out.signals.values;
% chillerByPassValve.rho.in = rho_ChillerByPassValve_in.signals.values;
% chillerByPassValve.rho.outB = rho_ChillerByPassValve_outB.signals.values;
% chillerByPassValve.rho.outC = rho_ChillerByPassValve_outC.signals.values;
% battery.coolant.SC3.rho = rho_coolant_battery_in.signals.values;
% battery.coolant.SC4.rho = rho_coolant_battery_out.signals.values;
% % Temperatures (K)
% chiller.TwoP.T.in = T_chiller_2P_in.signals.values;
% chiller.TwoP.T.out = T_chiller_2P_out.signals.values;
% chiller.TL.T.in = T_chiller_TL_in.signals.values;
% chiller.TL.T.out = T_chiller_TL_out.signals.values;
% chillerByPassValve.T.in = T_ChillerByPassValve_in.signals.values;
% chillerByPassValve.T.outB = T_ChillerByPassValve_outB.signals.values;
% chillerByPassValve.T.outC = T_ChillerByPassValve_outC.signals.values;
% compressor.fluid.T.in = T_comp_in.signals.values;
% compressor.fluid.T.out = T_comp_out.signals.values;
% condenser.TwoP.T.in = T_cond_2P_in.signals.values;
% condenser.TwoP.T.out = T_cond_2P_out.signals.values;
% battery.coolant.SC3.T = T_coolant_battery_in.signals.values;
% battery.coolant.SC4.T = T_coolant_battery_out.signals.values;
% % Internal energies (J/kg)
% chiller.TwoP.u.in = u_chiller_2P_in.signals.values;
% chiller.TwoP.u.out = u_chiller_2P_out.signals.values;
% chiller.TL.u.in = u_chiller_TL_in.signals.values;
% chiller.TL.u.out = u_chiller_TL_out.signals.values;
% chillerByPassValve.u.in = u_ChillerByPassValve_in.signals.values;
% chillerByPassValve.u.outB = u_ChillerByPassValve_outB.signals.values;
% chillerByPassValve.u.outC = u_ChillerByPassValve_outC.signals.values;
% compressor.fluid.u.in = u_comp_in.signals.values;
% compressor.fluid.u.out = u_comp_out.signals.values;
% condenser.TwoP.u.in = u_cond_2P_in.signals.values;
% condenser.TwoP.u.out = u_cond_2P_out.signals.values;
% battery.coolant.SC3.u = u_coolant_battery_in.signals.values;
% battery.coolant.SC4.u = u_coolant_battery_out.signals.values;
% % Specific volume (m^3/kg)
% chiller.TwoP.v.in = v_chiller_2P_in.signals.values;
% chiller.TwoP.v.out = v_chiller_2P_out.signals.values;
% compressor.fluid.v.in = v_comp_in.signals.values;
% compressor.fluid.v.out = v_comp_out.signals.values;
% condenser.TwoP.v.in = v_cond_2P_in.signals.values;
% condenser.TwoP.v.out = v_cond_2P_out.signals.values;
% compressor.fluid.vL.in = vL_comp_in.signals.values;
% compressor.fluid.vL.out = vL_comp_out.signals.values;
% compressor.fluid.vV.in = vV_comp_in.signals.values;
% compressor.fluid.vV.out = vV_comp_out.signals.values;
% % Vapor fraction (-)
% chiller.TwoP.x.in = x_chiller_2P_in.signals.values;
% chiller.TwoP.x.out = x_chiller_2P_out.signals.values;
% compressor.fluid.x.in = x_comp_in.signals.values;
% compressor.fluid.x.out = x_comp_out.signals.values;
% condenser.TwoP.x.out = x_cond_2P_out.signals.values;
% condenser.TwoP.x.in = x_cond_2P_in.signals.values;
% % Enthalpy (J/kg)
% chiller.h_2P_in = h_chiller_2P_in.signals.values;
% chiller.h_2P_out =  h_chiller_2P_out.signals.values;
% chiller.h_TL_in = h_chiller_TL_in.signals.values;
% chiller.h_TL_out = h_chiller_TL_out.signals.values;
% compressor.h_2P_in = h_comp_in.signals.values;
% compressor.h_2P_out = h_comp_out.signals.values;
% condenser.h_2P_in = h_cond_2P_in.signals.values;
% condenser.h_2P_out = h_cond_2P_out.signals.values;




%% Not useful for now
% % Compute volumetric efficiency compressor
% eta_Vnominal = 0.9;
% gamma = 1.13;
% p_in_nom = 0.3; %MPa
% beta_nom = 4.6;
% vr_nominal = ((beta_nom*p_in_nom)/(p_in_nom))^(1/gamma);
% C = (1-eta_Vnominal)/(vr_nominal-1);
% VolumetricEfficiency.time = time;
% VolumetricEfficiency.values = zeros(length(compressor.fluid.v.out.time),1);
% for t = 1:1:length(compressor.fluid.v.out.time)
%     VolumetricEfficiency.values(t) = 1 + C -C*(compressor.fluid.v.in.signals.values(t)/compressor.fluid.v.out.signals.values(t));
% end
% compressor.VolumetricEfficiency = VolumetricEfficiency;
